<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet fourteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">EMITIR GUIA DE REMISION</h4>
            <br>

            <form class="ui form" id="frmNuevo" autocomplete="off">

                <input type="hidden" name="id_venta" value="<?php echo e($venta->id_venta); ?>" readonly>

                <div class="three fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Nombre de Cliente</div>
                    </div>
                    <div class="eleven wide field">
                        <div class="ui small input">
                            <input type="text" value="<?php echo e($venta->cliente->nombre); ?>" readonly>
                        </div>  
                    </div>
                </div>

                <div class="four fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label"><?php echo e($venta->cliente->tipo_documento->nombre); ?> del Cliente</div>
                    </div>
                    <div class="four wide field">
                        <div class="ui small input">
                            <input type="text" value="<?php echo e($venta->cliente->numero_documento); ?>" readonly>
                        </div> 
                    </div>
                    <div class="four wide field">
                        <div class="ui fluid large white label">N° <?php echo e($venta->tipo_comprobante->nombre); ?> DE VENTA</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input">
                            <input type="text" value="<?php echo e($venta->nombre_comprobante); ?>" readonly>
                        </div> 
                    </div>
                </div> 

                <div class="ui divider"></div>
                                <br>

                <div class="three fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Direccion de Partida</div>
                    </div>
                    <div class="eleven wide field">
                        <div class="ui small input">
                            <input type="text" maxlength="200" name="punto_partida" value="<?php echo e($empresa->direccion); ?>" oninput="$.upperCase(this)">
                        </div>  
                    </div>
                </div>

                <div class="three fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Direccion de Llegada</div>
                    </div>
                    <div class="eleven wide field">
                        <div class="ui small input">
                            <input type="text" maxlength="200" name="punto_llegada" value="<?php echo e($venta->cliente->direccion); ?>" oninput="$.upperCase(this)">
                        </div> 
                    </div>
                </div>

                <div class="four fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Nombre Empresa de Transporte</div>
                    </div>
                    <div class="six wide field">
                        <div class="ui small input">
                            <input type="text" maxlength="200" id="nombre_transportista" name="nombre_transportista" oninput="$.upperCase(this)">
                        </div> 
                    </div>
                    <div class="two wide field">
                        <div class="ui fluid small green button btn_buscar_cliente" title="Clic para ver empresa de transportes"><i class="search icon"></i>VER</div>
                    </div>
                    <div class="three wide field">
                         <select class="ui small search selection dropdown" name="motivo">
                            <option value="">Motivo de Traslado</option>
                            <option value="VENTA">Venta</option>
                            <option value="COMPRA">Compra</option>
                            <option value="VENTA SUJETA A CONFIRMAR">Venta Sujeta a Confirmar</option>
                            <option value="CONSIGNACION">Consignacion</option>
                            <option value="DEVOLUCION">Devolucion</option>
                            <option value="ENTRE ESTABLECIMIENTOS DE LA MISMA EMPRESA">Entre establecimientos de la misma empresa</option>
                            <option value="PARA TRANSFORMACION">Para Transformacion</option>
                            <option value="RECOJO DE BIENES TRANSFORMADOS">Recojo de Bienes Transformados</option>
                            <option value="EMISOR ITINERANTE">Emisor Itinerante</option>
                            <option value="ZONA PRIMARIA">Zona Primaria</option>
                            <option value="IMPORTACION">Importacion</option>
                            <option value="EXPORTACION">Exportacion</option>
                        </select>  
                    </div>
                </div>

                <div class="four fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">RUC Empresa de Transporte</div>
                    </div>

                    <div class="four wide field">
                        <div class="ui action small input" >
                              <input type="text" id="documento_transportista" name="documento_transportista"  placeholder="Buscar..." maxlength="11">
                              <div class="ui icon button" id="loading_doc" title="Clic para Consultar"><i class="search icon"></i>&nbsp;SUNAT</div>
                        </div>
                    </div>


                    
                    <div class="four wide field">
                        <div class="ui fluid large white label">DNI de Chofer</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input">
                            <input type="text"  id="licencia" name="licencia" maxlength="8" oninput="$.upperCase(this)">
                        </div> 
                    </div>
                </div> 

                <div class="four fields">
                    <div class="four wide field">
                        <div class="ui fluid large white label">Placa del Vehiculo</div>
                    </div>
                    <div class="four wide field">
                        <div class="ui small input">
                            <input type="text" id="marca_placa"  name="marca_placa" maxlength="50" oninput="$.upperCase(this)">
                        </div> 
                    </div>
                    <div class="four wide field">
                        <div class="ui fluid large white label">Fecha de Traslado</div>
                    </div>
                    <div class="three wide field">
                        <div class="ui small input">
                            <input type="text" class="fecha hasDate" name="fecha_traslado" >
                        </div> 
                    </div>
                </div>   
            </form>
            <br>
            <div class="ui divider"></div>

            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Producto</th>
                        <th class="center aligned" data-tooltip="Presentacion del producto" data-position="top center" data-inverted="">Presentacion</th>
                        <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">Unidad de Medida</th>
                        <th class="center aligned" data-tooltip="Cantidad vendida" data-position="top center" data-inverted="">Cantidad</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    <?php $__currentLoopData = $detalle_venta; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr data-table="<?php echo e($venta->id_detalle_venta); ?>">
                        <td><a href="<?php echo e(url('producto/editar/'.$venta->id_producto)); ?>" title="Clic para ver informacion"><?php echo e(ucwords(mb_strtolower($venta->producto->nombre))); ?> <?php echo e($venta->producto->descripcion); ?></a></td>
                        <td><?php echo e($venta->producto->tipo_presentacion->nombre); ?></td>
                        <td><?php echo e($venta->producto->unidad_medida->nombre); ?></td>
                        <td><?php echo e($venta->cantidad); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div class="form_footer">
                <a class="ui small left  floated default button" href="<?php echo e(URL::previous()); ?>"><i class="arrow left icon"></i>REGRESAR</a>
                <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>EMITIR GUIA</div>
            </div>

        </div>
    </div>

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="circular inverted white shipping fast icon"></i>Emitir Guia de Remision</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea emitir la guia de remision?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para confirmar"> <i class="checkmark icon"></i>Emitir</div>
        </div>
    </div>
    <!--end register modal -->

    <!--start buscar cliente modal -->
    <div class="ui standard large modal" id="buscar_cliente_modal">
        <div class="header">Buscar Transportista</div>
        <div class="scrolling content">
  
            <div class="ui action small input"  autocomplete="off">
                <input type="text" id="buscar_cliente" name="buscar_cliente" placeholder="Cliente a buscar...">
                <div class="ui icon button" id="btn_buscar_cli" title="Clic para buscar"><i class="search icon"></i></div>
            </div> 
            <table class="ui celled striped table" id="tabla_clientes">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Empresa de Transportes</th>
                        <th class="head_table">Numero de RUC</th>
                        <th class="head_table">Placa Vehiculo</th>
                        <th class="head_table">DNI Chofer</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tbody_clientes">
                   <?php /**/ $i = 1/**/ ?>
                    <?php $__currentLoopData = $transportista; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($i); ?></td>
                        <td><?php echo e($row->nombre_transportista); ?></td>
                        <td><?php echo e($row->documento_transportista); ?></td>
                        <td><?php echo e($row->licencia); ?></td>
                        <td><?php echo e($row->marca_placa); ?></td>
                        <td>                            
                            <div class="ui mini vertical animated positive button btn_seleccionar_cliente" title="Seleccionar este cliente" data-nombre="<?php echo e($row->nombre_transportista); ?>" data-documento="<?php echo e($row->documento_transportista); ?>" data-dni="<?php echo e($row->licencia); ?>" data-placa="<?php echo e($row->marca_placa); ?>">
                                <div class="hidden content">Elegir</div>
                                <div class="visible content"><i class="check icon"></i></div>
                            </div>
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="actions" >
            <div class="ui left floated red right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
        </div>
    </div>
    <!--end buscar cliente modal -->
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/guia/nuevo.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>