<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDeliveryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('delivery', function (Blueprint $table) {
            $table->integer('id_delivery')->autoIncrement();
            $table->integer('id_usuario')->nullable(); 
            $table->integer('id_local')->nullable(); 
            $table->string('nombre', 200)->nullable(); 
            $table->string('numero_documento', 15)->nullable();
            $table->string('direccion', 200)->nullable();
            $table->string('telefono', 20)->nullable();
            $table->string('email', 50)->nullable();
            $table->string('latitud', 20)->nullable();
            $table->string('longitud', 20)->nullable();


            $table->date('fecha_emision')->nullable();
            $table->decimal('total', 9, 2)->nullable();
            $table->string('metodo_pago', 15)->nullable(); // CONTRAENTREGA, ONLINE
            $table->string('estado_pago', 15)->nullable(); // solo si es web -> PENDIENTE, PAGADO, CANCELADO

            $table->string('observacion', 200)->nullable();

            $table->string('estado_delivery', 20)->default('PENDIENTE'); // PENDIENTE, ATENDIDO, CANCELADO

            $table->tinyInteger('estado')->default('1'); 
            $table->timestamps();

            $table->foreign('id_local')
                  ->references('id_local')->on('local')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');

            $table->foreign('id_usuario')->references('id_usuario')->on('usuarios');  


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('delivery');
    }
}
