<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDetalleProformaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_proforma', function (Blueprint $table) {
            $table->integer('id_detalle_proforma')->autoIncrement();
            $table->integer('id_proforma');
            $table->integer('id_producto');
            $table->decimal('cantidad', 15, 6);
            $table->decimal('precio', 15, 6);
            $table->decimal('descuento', 9, 2);
            $table->decimal('subtotal', 9, 2);
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();
            
            $table->foreign('id_proforma')
                  ->references('id_proforma')->on('proformas')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');

            $table->foreign('id_producto')->references('id_producto')->on('productos'); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_proforma');
    }
}
