<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Baja extends Model
{
    protected $table = 'bajas';
    protected $primaryKey = 'id_baja';

    protected $fillable = [
        'id_baja', 'id_usuario', 'id_local', 'id_venta', 'id_nota', 'id_tipo_comprobante', 'nombre_baja',  'fecha_emision', 'fecha_referencia', 'serie', 'numero', 'motivo',  'estado_envio' , 'mensaje_envio',  'estado'
    ];

    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'id_usuario');
    }
    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }
    public function venta()
    {
        return $this->belongsTo('App\Models\Venta', 'id_venta');
    }
    public function nota()
    {
        return $this->belongsTo('App\Models\Nota', 'id_nota');
    }
    public function tipo_comprobante()
    {
        return $this->belongsTo('App\Models\TipoComprobante', 'id_tipo_comprobante');
    }

}
