<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\Local;
use App\Models\Proveedor;
use App\Models\Usuario;
use App\Models\Venta;
use App\Models\Producto;

class ReporteController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function comprobantes()
    {
        $data = [
            'locales' => Local::where('estado', 1)->where('id_tipo_local', 1)->get(), 
        ];

        return view('reporte.comprobantes', $data); 
    }

    public function ventas()
    {
        $data = [
            'locales' => Local::where('estado', 1)->where('id_tipo_local', 1)->get(), 
        ];

        return view('reporte.ventas', $data); 
    }

    public function compras()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
            'proveedores' => Proveedor::where('estado', 1)->get(), 
        ];

        return view('reporte.compras', $data); 
    }

    public function usuarios()
    {
        $data = [
            'usuarios' => Usuario::where('estado', 1)->get(), 
            'locales' => Local::where('estado', 1)->get(), 
            'consulta' => DB::table('ventas')->join('usuarios', 'ventas.id_usuario', '=', 'usuarios.id_usuario')
                     ->select('ventas.id_usuario', 'nombres', 'apellidos', 'dni', 'fecha_venta', DB::raw('count(*) as ventas, sum(total_venta) as monto'))
                     ->where('ventas.estado', 1)
                     ->where('ventas.id_nota', null)
                     ->where('ventas.fecha_venta', date('Y-m-d'))
                     ->groupBy('ventas.id_usuario')
                     ->get(),
        ];

        return view('reporte.usuarios', $data); 
    }

    public function detalles($id) 
    {
        return view('reporte.detalles', [
            'usuario' => Usuario::where(['id_usuario' => $id])->first(),
            'data' => Venta::with(['local', 'cliente', 'tipo_comprobante'])->where('id_nota',null)->where(['id_usuario' => $id, 'fecha_venta' => date('Y-m-d')])->get(),
            'total' => DB::table('ventas')->where('id_nota',null)->where(['id_usuario' => $id, 'fecha_venta' => date('Y-m-d')])->sum('total_venta'),
        ]); 
    }

    public function productos_vendidos()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.productos_vendidos', $data); 
    }

    public function productos_comprados()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.productos_comprados', $data); 
    }

    public function productos_vencidos()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.productos_vencidos', $data); 
    }

    public function stock()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.stock', $data); 
    }

    public function egresos()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.egresos', $data); 
    }

    public function guia()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.guia', $data); 
    }

    public function bajas()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.baja', $data); 
    }

    public function pedidos()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.pedidos', $data); 
    }

    public function kardex()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.kardex', $data); 
    }

    public function deudores()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.deudores', $data); 
    }

    public function tipo_impuesto()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.tipo_impuesto', $data); 
    }

    public function delivery()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
        ];

        return view('reporte.delivery', $data); 
    }

    public function productos_personal()
    {
        $data = [
            'locales' => Local::where('estado', 1)->get(), 
            'usuarios' => Usuario::where('estado', 1)->get(), 
        ];

        return view('reporte.productos_personal', $data); 
    } 
    
    public function productos_historial()
    {
        $data = [
            'productos' => Producto::where('estado', 1)->get(), 
        ];

        return view('reporte.productos_historial', $data); 
    }

}