<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\UploadFile;
use Auth;
use App\Models\Producto;
use App\Models\TipoPresentacion;
use App\Models\UnidadMedida;
use App\Models\Local;
use App\Models\ProductoLocal;
use App\Models\Empresa;
use App\Models\DetalleProforma;
use App\Models\Proforma;
use App\Models\DetalleDelivery;
use App\Models\Delivery;

class ProductoController extends Controller
{
	public function __construct()
    {
        $this->middleware('auth:usuario');
    }
    
	public function listar()
    {
        $res = ProductoLocal::with(['producto'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->paginate(20);

        return view('producto.listar', [ 'data' => $res]); 
	}

	public function nuevo()
    {
	 	$data = [
            'locales' => Local::where('estado', 1)->get(), 
            'empresa' => Empresa::where('estado', 1)->first(), 
            'tipo_presentacion' => TipoPresentacion::all(), 
            'unidad_medida' => UnidadMedida::all() 
        ];
	 	return view('producto.nuevo', $data); 
	}

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $precio = $request->precio;
            $precio_may = $request->precio_mayorista;
            $precio_compra = $request->precio_compra;
            if(!is_null($request->precio_compra)) {
                if($request->tipo_precio == 2){
                    $precio = round(($request->precio_compra + ($request->precio_compra*($request->precio/100))), 1); 
                }
                if($request->tipo_precio_2 == 2 && $request->precio_mayorista != null){
                    $precio_may = round(($request->precio_compra + ($request->precio_compra*($request->precio_mayorista/100))), 1); 
                }
            }
            else {
                $request['precio_compra'] = 0;
            }
            
            $utilidad = (($precio - $request->precio_compra) < 0 ) ? 0 : ($precio - $request->precio_compra);
            $request->request->add(['utilidad' => $utilidad]); 
            $request['precio'] = $precio;
            $request['precio_mayorista'] = $precio_may;

            $res = Producto::create($request->all());


            if ($res && $request->file('imagen')) {
                $image = $request->file('imagen');
                $nuevo_nombre = 'producto_'.$res->id_producto.'.'.$image->getClientOriginalExtension();
                $pi = Producto::find($res->id_producto);
                $pi->url_imagen = $nuevo_nombre;
                $pi->save(); 

                $image->move(public_path('img/productos'), $nuevo_nombre);
            }

            if ($res && $request->id_local) 
            {
                $alerta = $request->stock_alerta  ? $request->stock_alerta : 10; 

                ProductoLocal::create([
                    'id_producto' => $res->id_producto, 
                    'id_local' => $request->id_local, 
                    'stock' => 1000000+$request->cantidad, 
                    'stock_alerta' =>  $alerta, 
                ]);
            }
            
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
	}

    public function registrar_venta(Request $request)
    {
        if ($request->ajax())
        {    
            if ($request->precio == 0) {
                $request['precio'] = 1;
            }

            $data = Producto::create($request->all());

            if ($data) 
            {
                $prod = ProductoLocal::create([
                    'id_producto' => $data->id_producto, 
                    'id_local' => Auth::guard("usuario")->user()->id_local, 
                    'stock' => 1000000, 
                ]);
            }

            $res = ProductoLocal::with('producto', 'producto.unidad_medida', 'producto.tipo_presentacion')->where('id_producto_local', $prod->id_producto_local)->first();
            
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
    }



    public function registrar_proforma(Request $request)
    {
        if ($request->ajax())
        {    
            $data = Producto::create($request->all());

            if ($data) 
            {
                $prod = ProductoLocal::create([
                    'id_producto' => $data->id_producto, 
                    'id_local' => Auth::guard("usuario")->user()->id_local, 
                ]);

                 
                $detalle= [
                    'id_proforma' => $request->id_proforma, 
                    'id_producto' => $data->id_producto, 
                    'cantidad' => $request->cantidad, 
                    'precio' => $request->precio, 
                    'descuento' => '0.00', 
                    'subtotal' => $request->cantidad*$request->precio, 
                ];

                $res = DetalleProforma::create($detalle);

                if ($res) 
                {
                    $data2 = Proforma::find($request->id_proforma);
                    $data2->saldo = ($data2->total + ($request->cantidad*$request->precio)) - $data2->adelanto;
                    $data2->total = $data2->total + ($request->cantidad*$request->precio);

                    $data2->save();
                }


            }

            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
    }

    public function registrar_delivery(Request $request)
    {
        if ($request->ajax())
        {    
            $data = Producto::create($request->all());

            if ($data) 
            {
                $prod = ProductoLocal::create([
                    'id_producto' => $data->id_producto, 
                    'id_local' => Auth::guard("usuario")->user()->id_local, 
                ]);

                 
                $detalle= [
                    'id_delivery' => $request->id_delivery, 
                    'id_producto' => $data->id_producto, 
                    'cantidad' => $request->cantidad, 
                    'precio' => $request->precio, 
                    'descuento' => '0.00', 
                    'subtotal' => $request->cantidad*$request->precio, 
                ];

                $res = DetalleDelivery::create($detalle);

                if ($res) 
                {
                    $data2 = Delivery::find($request->id_delivery);
                    $data2->total = $data2->total + ($request->cantidad*$request->precio);
                    $data2->save();
                }

            }

            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
    }



	public function editar($id)
    {
        $res = [
            'data' => Producto::where(['id_producto' => $id , 'estado' => 1])->first(), 
            'cantidad' => ProductoLocal::where(['id_producto' => $id , 'id_local' => Auth::guard("usuario")->user()->id_local, 'estado' => 1])->first(), 
            'tipo_presentacion' => TipoPresentacion::all(), 
            'unidad_medida' => UnidadMedida::all() 
        ];
        return view('producto.editar', $res); 
    }

    public function actualizar(Request $request)
    {
        if ($request->ajax())
        {
            $data = Producto::find($request->id_producto);


            $data->nombre           	 = $request->nombre; 
            $data->codigo_barras         = $request->codigo_barras;
            $data->descripcion           = $request->descripcion;
            $data->tipo_producto     	 = $request->tipo_producto;
            $data->fecha_vencimiento     = $request->fecha_vencimiento;
            $data->lote                  = $request->lote;
            $data->id_tipo_presentacion  = $request->id_tipo_presentacion;
            $data->id_unidad_medida      = $request->id_unidad_medida;
            $data->situacion_impuesto    = $request->situacion_impuesto;
            $data->tipo_impuesto         = $request->tipo_impuesto;
            $data->valor_impuesto        = $request->valor_impuesto;
            //$data->precio                = $request->precio;
            //$data->utilidad              = $request->utilidad;
            $data->precio_compra         = $request->precio_compra;
            //$data->precio_mayorista      = $request->precio_mayorista;
            $data->icbper                = $request->icbper;

            $precio = $request->precio;
            $precio_may = $request->precio_mayorista;
            if(!is_null($request->precio_compra)) {
                if($request->tipo_precio == 2){
                    $precio = round(($request->precio_compra + ($request->precio_compra*($request->precio/100))), 1); 
                }
                if($request->tipo_precio_2 == 2 && $request->precio_mayorista != null){
                    $precio_may = round(($request->precio_compra + ($request->precio_compra*($request->precio_mayorista/100))), 1); 
                }
            }
            else {
                $data->precio_compra = 0;
            }
            
            $data->utilidad = (($precio - $data->precio_compra) < 0 ) ? 0 : ($precio - $data->precio_compra);
            $data->precio = $precio;
            $data->precio_mayorista = $precio_may;

            if ($request->file('imagen')) {
                $image = $request->file('imagen');
                $nuevo_nombre = 'producto_'.$request->id_producto.'.'.$image->getClientOriginalExtension();
                $data->url_imagen = $nuevo_nombre;
                $image->move(public_path('img/productos'), $nuevo_nombre);
            }
            
            $res  = $data->save();

            $prod =  ProductoLocal::where(['id_producto' => $request->id_producto , 'id_local' => Auth::guard("usuario")->user()->id_local, 'estado' => 1])->first();

           if ($prod) {
                $data2 = ProductoLocal::find($prod->id_producto_local);
                $data2->stock  = $request->cantidad + 1000000;
                $data2->stock_alerta= $request->alerta;
                $data2->save(); 
            }
            else {
                $datos= [
                    'id_local' => Auth::guard("usuario")->user()->id_local, 
                    'id_producto' => $request->id_producto, 
                    'stock' => $request->cantidad + 1000000,
                    'stock_alerta' => $request->alerta,
                ];
                ProductoLocal::create($datos);
            }

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

    public function eliminar(Request $request)
    {
    	if ($request->ajax())
        {
	      	/*$data = Producto::find($request->id_producto);
            $data->estado = 0;
            $res  = $data->save();*/

            $prod = ProductoLocal::where('id_producto', $request->id_producto)->where('id_local', Auth::guard("usuario")->user()->id_local)->first();
            $data1 = ProductoLocal::find($prod->id_producto_local);
            $data1->estado = 0;
            $data1->stock = 1000000;
            $res = $data1->save();

	        return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
    	}
    }

    public function getById(Request $request)
    {
        if ($request->ajax())
        {
            $res = [
                'producto' => Producto::with(['tipo_presentacion', 'unidad_medida'])->find($request->id_producto)
            ];
            return response()->json($res);  
        }
    }

    public function getById2(Request $request)
    {
        if ($request->ajax())
        {
            $res = Producto::with(['tipo_presentacion', 'unidad_medida'])->find($request->id_producto);
            return response()->json($res);  
        }
    }

    public function getByCodBarras(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->codigo_barras))
            {
                $res = Producto::with(['tipo_presentacion', 'unidad_medida'])->where('codigo_barras', $request->codigo_barras)->where('estado', 1)->first();
            }
            return response()->json($res);  
        }
    }

    public function buscar(Request $request)
    {
        if ($request)
        {
            $id = TipoPresentacion::where('nombre', 'LIKE', '%'.$request->search.'%')->first();
            $res = ProductoLocal::join('productos', 'productos.id_producto','=', 'producto_local.id_producto')->where(function ($query) {
                        $query->where('productos.estado', '=', 1)->where('producto_local.estado', '=', 1)->where('producto_local.id_local', Auth::guard("usuario")->user()->id_local);
                    })->where(function ($query)  use ($request, $id) {
                        $query->where('productos.nombre', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('productos.descripcion', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('productos.codigo_barras', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('productos.fecha_vencimiento', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('productos.lote', 'LIKE', '%'.$request->search.'%')
                              ->orWhere('productos.id_tipo_presentacion', '=', $id ? $id->id_tipo_presentacion : '');
                    })->paginate(20);

            $res->appends(['search' => $request->search]);        
        	return view('producto.listar', ['data' => $res]); 
        }
    }

    public function existeCampo(Request $request)
    {
        if ($request->ajax())
        {    
            $val = 0;
            if ($request->valor != '') {
                $val = Producto::where($request->campo, '=', $request->valor)->where('estado', 1)->count();
            }
            
            return response()->json($val); 
        }
    }

    public function existeCampoEditar(Request $request)
    {
        if ($request->ajax())
        {    
            $val = 0;
            if ($request->valor != '') {
                $val = Producto::where($request->campo, '=', $request->valor)->where('id_producto', '<>', $request->id_producto)->where('estado', 1)->count();
            }
            
            return response()->json($val); 
        }
    }


    public function getByNombre(Request $request)
    {
        if ($request->ajax())
        {
            $res = null;
            if (!empty($request->search))
            {
                $res =  Producto::with(['tipo_presentacion', 'unidad_medida'])->where(function ($query) {
                        $query->where('estado', '=', 1);
                    })->where(function ($query)  use ($request) {
                        $query->where('nombre', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('descripcion', 'LIKE',  '%'.$request->search.'%')
                              ->orWhere('codigo_barras', 'LIKE',  '%'.$request->search.'%');
                    })->get();
            }
            return response()->json($res); 
        }
    }


    public function crearPresentacion()
    {
        return view('producto.presentacion'); 
    }

    public function crearUnidad()
    {
        return view('producto.unidad'); 
    }

    public function registrar_presentacion(Request $request)
    {
        if ($request->ajax())
        {    
            $res = TipoPresentacion::create($request->all());
            
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
    }

    public function registrar_unidad(Request $request)
    {
        if ($request->ajax())
        {    
            $res = UnidadMedida::create($request->all());

            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
    }





}
