<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\Baja;
use App\Models\Venta;
use App\Models\Nota;
use App\Models\Empresa;


class BajaController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }
    

    public function listar() // listar electronico
    {
        $res = Baja::where('estado', 1)->orderBy('fecha_emision', 'desc')->paginate(20); 

        return view('baja.listar', [ 'data' => $res]);
    }

    public function estado($id) // electronico
    {
        $estado = ['ACEPTADO', 'RECHAZADO', 'NO ENVIADO', 'PENDIENTE', 'REGISTRADO'];

        $res = Baja::where('estado_envio', $estado[$id])->where('estado', 1)->orderBy('fecha_referencia', 'desc')->paginate(10);

        return view('baja.listar', [ 'data' => $res]); 
    }

    public function detalles($id)
    {
        return view('baja.detalles', [
            'data' => Baja::with(['local', 'usuario', 'tipo_comprobante'])->where(['id_baja' => $id , 'estado' => 1])->first(),
            'empresa' => Empresa::where(['id_empresa' => 1 , 'estado' => 1])->first(),
        ]); 
    }

    public function emitir($id)
    {

        $ayer = strtotime('-7 day', strtotime(date('Y-m-d')));
        $ayer = date('Y-m-j', $ayer);

        $bajas = Baja::where('id_tipo_comprobante', $id)->where('estado', 1)->get();  
        if ($id == 1) 
        {
            $res = Venta::with(['local', 'tipo_comprobante'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_tipo_comprobante', $id)->where('estado_envio', 'ACEPTADO')->where('estado', 1)->where('fecha_venta', '>', $ayer)->orderBy('created_at', 'desc')->paginate(20);    

            return view('baja.emitir', [ 'data' => $res, 'bajas' => $bajas, 'tipo' => $id]); 
        }

        if ($id == 3 || $id == 4) 
        {
            $res = Nota::with(['venta', 'local', 'tipo_comprobante'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('id_tipo_comprobante', $id)->where('estado_envio', 'ACEPTADO')->where('estado', 1)->where('fecha_emision', '>', $ayer)->orderBy('created_at', 'desc')->paginate(20);

            return view('baja.emitir', [ 'data' => $res, 'bajas' => $bajas , 'tipo' => $id ]);
        }
    }


    public function nuevo($id, $tipo)
    {
        if ($tipo == 1 || $tipo == 2) {

            $res = Venta::with(['local', 'tipo_comprobante'])->where('id_venta', $id)->where('estado_envio', 'ACEPTADO')->where('estado', 1)->first();
        }

        if ($tipo == 3 || $tipo == 4) {

            $res = Nota::with(['local', 'tipo_comprobante'])->where('id_nota', $id)->where('estado_envio', 'ACEPTADO')->where('estado', 1)->first();
        }

        return view('baja.nuevo', [ 'data' => $res, 'tipo' => $tipo ]);
    }

    public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $id_local = Auth::guard("usuario")->user()->id_local;
            $id_usuario = Auth::guard("usuario")->user()->id_usuario;

            $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
            $request->request->add(['id_local' => Auth::guard("usuario")->user()->id_local]);
            $request->request->add(['estado_envio' => 'REGISTRADO']);
            $request->request->add(['mensaje_envio' => 'La baja fue registrada correctamente']);
            $request->request->add(['fecha_emision' => date('Y-m-d')]);

            $res = Baja::create($request->all());
            
            if ($res) {
                //Creamos documentos XML
                $xml = new XmlController();
                $xml->crearBaja($res->id_baja);    
            }

            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
    }


}
